﻿using System;

namespace UMK.WzorceStrukturalne
{
    public interface IUrządzenieRTV
    {
        void Włącz();
        void Wyłącz();
        void UstawKanał(int numerKanału);
    }

    public class Telewizor : IUrządzenieRTV
    {
        public void Włącz()
        {
            Console.WriteLine("Telewizor zostal wlaczony");
        }
        public void Wyłącz()
        {
            Console.WriteLine("Telewizor zostal wylaczony");
        }
        public void UstawKanał(int numerKanału)
        {
            Console.WriteLine("Kanal w telewizorze zmieniony na: " + numerKanału);
        }
    }

    public class Radio : IUrządzenieRTV
    {
        public void Włącz()
        {
            Console.WriteLine("Radio zostalo wlaczone");
        }
        public void Wyłącz()
        {
            Console.WriteLine("Radio zostalo wylaczone");
        }
        public void UstawKanał(int numerKanału)
        {
            Console.WriteLine("Kanal w radiu zmieniony na: " + numerKanału);
        }
    }

    //Most
    class Pilot
    {
        private IUrządzenieRTV urządzenie;
        private int poprzedniKanał = 1, bieżącyKanał = 1;

        public Pilot(IUrządzenieRTV urządzenie)
        {
            this.urządzenie = urządzenie;           
        }

        public void WłączUrządzenie()
        {
            urządzenie.Włącz();
            UstawKanałUrządzenia(bieżącyKanał);
        }

        public void WyłączUrządzenie()
        {
            urządzenie.Wyłącz();
        }

        public void UstawKanałUrządzenia(int numerKanału)
        {
            urządzenie.UstawKanał(numerKanału);
            poprzedniKanał = bieżącyKanał;
            bieżącyKanał = numerKanału;
        }

        

        

        public void PrzywróćPoprzedniKanał()
        {
            UstawKanałUrządzenia(poprzedniKanał);
        }
    }
}
