﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Singleton12
{
    class Program
    {
        class Klasa
        {
            public void Metoda()
            {
                Log log = Log.PobierzInstancję();
                log.Dodaj("B");                
            }
        }

        static void Main(string[] args)
        {
            Log log = Log.PobierzInstancję();
            log.Dodaj("A");
            new Klasa().Metoda();
            log.Dodaj("C");
            log.Zapisz();
        }

        class Log
        {
            #region Singleton
            private Log() { }

            private static Log instancja1 = null, instancja2 = null;

            private static Log bieżącaInstancja = null;

            public static Log PobierzInstancję()
            {
                if (instancja1 == null)
                {
                    instancja1 = new Log();
                    instancja2 = new Log();
                    bieżącaInstancja = instancja2;
                }
                if (bieżącaInstancja == instancja1) bieżącaInstancja = instancja2; else bieżącaInstancja = instancja1;
                return bieżącaInstancja;
            }
            #endregion

            //private IFormatProvider fp = System.Globalization.CultureInfo.InvariantCulture; //USA
            private IFormatProvider fp = new System.Globalization.CultureInfo("pl-PL"); //Polska
            private string ścieżka = System.IO.Path.Combine(System.Environment.GetFolderPath(Environment.SpecialFolder.UserProfile), "log.txt");

            private List<string> komunikaty = new List<string>();

            public void Dodaj(string komunikat)
            {
                komunikaty.Add(DateTime.Now.ToString(fp) + " - " + komunikat);
            }

            public void Zapisz()
            {
                List<string> komunikaty = new List<string>();
                komunikaty.AddRange(instancja1.komunikaty);
                komunikaty.AddRange(instancja2.komunikaty);
                komunikaty.Sort();
                System.IO.File.WriteAllLines(ścieżka, komunikaty);
            }
        }
    }
}
