﻿using System;

namespace UMK.WzorceStrukturalne
{
    public interface IUrządzenieRTV
    {
        void Włącz();
        void Wyłącz();
        void UstawKanał(int numerKanału);
    }

    public class Telewizor : IUrządzenieRTV
    {
        public void Włącz()
        {
            Console.WriteLine("Telewizor zostal wlaczony");
        }
        public void Wyłącz()
        {
            Console.WriteLine("Telewizor zostal wylaczony");
        }
        public void UstawKanał(int numerKanału)
        {
            Console.WriteLine("Kanal w telewizorze zmieniony na: " + numerKanału);
        }
    }

    public class Radio : IUrządzenieRTV
    {
        public void Włącz()
        {
            Console.WriteLine("Radio zostalo wlaczone");
        }
        public void Wyłącz()
        {
            Console.WriteLine("Radio zostalo wylaczone");
        }
        public void UstawKanał(int numerKanału)
        {
            Console.WriteLine("Kanal w radiu zmieniony na: " + numerKanału);
        }
    }

    public class PilotZespolony //: IUrządzenieRTV
    {
        private IUrządzenieRTV[] urządzenia;

        public int NumerKanału, PoprzedniNumerKanału;

        public PilotZespolony(/*params IUrządzenieRTV[] urządzenia*/)
        {
            //this.urządzenia = urządzenia;
            urządzenia = new IUrządzenieRTV[3] { new Telewizor(), new Radio(), new Telewizor() };
            NumerKanału = 1;
            PoprzedniNumerKanału = 1;
        }

        public void WłączUrządzenie()
        {
            foreach(IUrządzenieRTV urządzenie in urządzenia)
                urządzenie.Włącz();
        }

        public void WyłączUrządzenie()
        {
            foreach (IUrządzenieRTV urządzenie in urządzenia)
                urządzenie.Wyłącz();
        }

        public void UstawKanałUrządzenia(int numerKanału)
        {
            foreach (IUrządzenieRTV urządzenie in urządzenia)
                urządzenie.UstawKanał(numerKanału);
            PoprzedniNumerKanału = NumerKanału;
            NumerKanału = numerKanału;
        }

        public void PrzywróćPoprzedniKanał()
        {
            UstawKanałUrządzenia(PoprzedniNumerKanału);
        }
    }
}
