﻿using System;

namespace UMK.WzorceStrukturalne
{
    public interface IUrządzenieRTV
    {
        void Włącz();
        void Wyłącz();
        void UstawKanał(int numerKanału);
    }

    public class Telewizor : IUrządzenieRTV
    {
        public void Włącz()
        {
            Console.WriteLine("Telewizor zostal wlaczony");
        }
        public void Wyłącz()
        {
            Console.WriteLine("Telewizor zostal wylaczony");
        }
        public void UstawKanał(int numerKanału)
        {
            Console.WriteLine("Kanal w telewizorze zmieniony na: " + numerKanału);
        }
    }

    public class Radio : IUrządzenieRTV
    {
        public void Włącz()
        {
            Console.WriteLine("Radio zostalo wlaczone");
        }
        public void Wyłącz()
        {
            Console.WriteLine("Radio zostalo wylaczone");
        }
        public void UstawKanał(int numerKanału)
        {
            Console.WriteLine("Kanal w radiu zmieniony na: " + numerKanału);
        }
    }

    public class Pilot //: IUrządzenieRTV
    {
        IUrządzenieRTV urządzenie;

        public int NumerKanału, PoprzedniNumerKanału;

        public Pilot(IUrządzenieRTV urządzenie)
        {
            this.urządzenie = urządzenie;
            NumerKanału = 1;
            PoprzedniNumerKanału = 1;
        }

        public void WłączUrządzenie()
        {
            urządzenie.Włącz();
        }

        public void WyłączUrządzenie()
        {
            urządzenie.Wyłącz();
        }

        public void UstawKanałUrządzenia(int numerKanału)
        {
            urządzenie.UstawKanał(numerKanału);
            PoprzedniNumerKanału = NumerKanału;
            NumerKanału = numerKanału;
        }

        public void PrzywróćPoprzedniKanał()
        {
            UstawKanałUrządzenia(PoprzedniNumerKanału);
        }
    }
}
